import usePreferences from "../../../hooks/usePreferences";

export const shippingCalculation = (data) => {
    const { preference: { decimal_digits } = {} } = usePreferences();

    let shippingOptionArray = [];
    if (
        !Array.isArray(data?.shipping) &&
        typeof data?.shipping === "object" &&
        Object.keys(data?.shipping).length > 0
    ) {
        for (let [index, item] of Object.keys(data?.shipping).entries()) {
            let singleOption = {
                index,
                label: item,
                selected: false,
                value: Number(data?.shipping[item]).toFixed(
                    Number(decimal_digits)
                ),
            };
            shippingOptionArray.push(singleOption);
        }
        shippingOptionArray[0]["selected"] = true;
    }
    return shippingOptionArray;
};
